/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.network.json;

import com.agricraft.agricore.core.AgriCore;
import com.agricraft.agricore.json.AgriSaver;
import com.agricraft.agricore.plant.fertilizer.AgriFertilizer;
import com.google.common.collect.ImmutableList;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.impl.v1.CoreHandler;
import com.infinityraider.agricraft.impl.v1.fertilizer.JsonFertilizer;
import com.infinityraider.agricraft.network.json.JsonSerializer;
import com.infinityraider.infinitylib.network.MessageBase;
import com.infinityraider.infinitylib.network.serialization.IMessageSerializer;
import java.nio.file.Path;
import java.util.List;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageSyncFertilizerJson
extends MessageBase {
    private AgriFertilizer fertilizer;
    private int index;
    private int count;

    public MessageSyncFertilizerJson() {
    }

    public MessageSyncFertilizerJson(AgriFertilizer fertilizer, int index, int count) {
        this.fertilizer = fertilizer;
        this.index = index;
        this.count = count;
    }

    public NetworkDirection getMessageDirection() {
        return NetworkDirection.PLAY_TO_CLIENT;
    }

    protected void processMessage(NetworkEvent.Context ctx) {
        if (this.index == 0) {
            AgriCore.getFertilizers().clearElements();
        }
        AgriCore.getFertilizers().addFertilizer(this.fertilizer);
        AgriCore.getLogger("agricraft-net").debug("Received Fertilizer {0} ({1} of {2}).", this.fertilizer.getLangKey(), this.index + 1, this.count);
        if (this.index == this.count - 1) {
            Path worldDir = CoreHandler.getJsonDir().resolve(this.getServerId());
            AgriSaver.saveElements(worldDir, AgriCore.getFertilizers().getAll());
            AgriCore.getFertilizers().getAll().stream().map(JsonFertilizer::new).forEach(AgriApi.getFertilizerAdapterizer()::registerAdapter);
        }
    }

    protected List<IMessageSerializer> getNecessarySerializers() {
        return ImmutableList.of(new JsonSerializer());
    }
}

