/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.impl.v1.plant;

import com.infinityraider.agricraft.api.v1.event.AgriRegistryEvent;
import com.infinityraider.agricraft.api.v1.plant.IAgriWeed;
import com.infinityraider.agricraft.api.v1.plant.IAgriWeedRegistry;
import com.infinityraider.agricraft.impl.v1.AgriRegistryAbstract;
import com.infinityraider.agricraft.impl.v1.crop.AgriGrowthRegistry;
import com.infinityraider.agricraft.impl.v1.plant.NoWeed;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AgriWeedRegistry
extends AgriRegistryAbstract<IAgriWeed>
implements IAgriWeedRegistry {
    public static final IAgriWeed NO_WEED = NoWeed.getInstance();
    private static final AgriWeedRegistry INSTANCE = new AgriWeedRegistry();

    public static AgriWeedRegistry getInstance() {
        return INSTANCE;
    }

    private AgriWeedRegistry() {
        this.directAdd(NO_WEED);
    }

    @Override
    public boolean add(@Nullable IAgriWeed object) {
        boolean result = super.add(object);
        if (object != null && result) {
            object.getGrowthStages().forEach(stage -> AgriGrowthRegistry.getInstance().add(stage));
        }
        return result;
    }

    @Override
    public boolean remove(@Nullable IAgriWeed element) {
        return NO_WEED != element && super.remove(element);
    }

    @Override
    @Nonnull
    public Stream<IAgriWeed> stream() {
        return super.stream().filter(IAgriWeed::isWeed);
    }

    @Override
    @Nullable
    protected AgriRegistryEvent<IAgriWeed> createEvent(IAgriWeed element) {
        return new AgriRegistryEvent.Weed(this, element);
    }

    @Override
    public IAgriWeed getNoWeed() {
        return NO_WEED;
    }
}

