/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.impl.v1.genetics;

import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGene;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenePair;
import com.infinityraider.agricraft.api.v1.genetics.IAllele;
import com.infinityraider.agricraft.api.v1.genetics.IMutator;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.impl.v1.genetics.AgriGenePair;
import com.infinityraider.agricraft.impl.v1.genetics.AgriMutationHandler;
import com.infinityraider.agricraft.impl.v1.plant.NoPlant;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.TranslationTextComponent;

public class GeneSpecies
implements IAgriGene<IAgriPlant> {
    public static final Vector3f COLOR_DOMINANT = new Vector3f(0.75f, 0.0f, 0.5f);
    public static final Vector3f COLOR_RECESSIVE = new Vector3f(0.5f, 0.0f, 0.75f);
    private static final GeneSpecies INSTANCE = new GeneSpecies();
    private final String id;
    private final TranslationTextComponent descr;

    public static GeneSpecies getInstance() {
        return INSTANCE;
    }

    private GeneSpecies() {
        this.id = "agri_species";
        this.descr = new TranslationTextComponent(AgriCraft.instance.getModId() + ".gene." + this.id);
    }

    @Nonnull
    public IAgriPlant defaultAllele(IAgriPlant plant) {
        return NoPlant.getInstance();
    }

    @Override
    @Nonnull
    public IAllele<IAgriPlant> getAllele(IAgriPlant value) {
        return value;
    }

    @Nonnull
    public IAgriPlant readAlleleFromNBT(@Nonnull CompoundNBT tag) {
        return AgriApi.getPlantRegistry().get(tag.func_74779_i("agri_plant")).orElse(NoPlant.getInstance());
    }

    @Override
    @Nonnull
    public Set<IAllele<IAgriPlant>> allAlleles() {
        return AgriApi.getPlantRegistry().stream().map(plant -> plant).collect(Collectors.toSet());
    }

    @Override
    @Nonnull
    public IMutator<IAgriPlant> mutator() {
        return AgriMutationHandler.getInstance().getActivePlantMutator();
    }

    @Override
    @Nonnull
    public IAgriGenePair<IAgriPlant> generateGenePair(IAllele<IAgriPlant> first, IAllele<IAgriPlant> second) {
        return new AgriGenePair<IAgriPlant>(this, first, second);
    }

    @Nonnull
    public TranslationTextComponent getGeneDescription() {
        return this.descr;
    }

    @Override
    @Nonnull
    public Vector3f getDominantColor() {
        return COLOR_DOMINANT;
    }

    @Override
    @Nonnull
    public Vector3f getRecessiveColor() {
        return COLOR_RECESSIVE;
    }

    @Override
    public int getComparatorWeight() {
        return 0;
    }

    @Override
    @Nonnull
    public String getId() {
        return this.id;
    }
}

