/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.impl.v1;

import com.agricraft.agricore.plant.AgriMutation;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.genetics.IAgriMutation;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.impl.v1.genetics.Mutation;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class JsonHelper {
    @Nonnull
    public static Optional<IAgriMutation> wrap(@Nullable AgriMutation mutation) {
        if (mutation == null) {
            return Optional.empty();
        }
        double chance = mutation.getChance();
        String mutationId = mutation.getChild().getId().replace("_plant", "_mutation");
        Optional child = AgriApi.getPlantRegistry().get(mutation.getChild().getId());
        if (!child.isPresent()) {
            return Optional.empty();
        }
        Optional parentOne = AgriApi.getPlantRegistry().get(mutation.getParent1().getId());
        Optional parentTwo = AgriApi.getPlantRegistry().get(mutation.getParent2().getId());
        if (!parentOne.isPresent() && !parentTwo.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(new Mutation(mutationId, chance, (IAgriPlant)child.get(), (IAgriPlant)parentOne.get(), (IAgriPlant)parentTwo.get()));
    }
}

