/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.handler;

import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.content.core.TileEntitySeedAnalyzer;
import com.infinityraider.agricraft.util.AnimatedScrollPosition;
import com.infinityraider.agricraft.util.PlayerAngleLocker;
import com.infinityraider.infinitylib.modules.dynamiccamera.DynamicCamera;
import com.infinityraider.infinitylib.modules.dynamiccamera.ModuleDynamicCamera;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.IngameMenuScreen;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class SeedAnalyzerViewPointHandler {
    private static final SeedAnalyzerViewPointHandler INSTANCE = new SeedAnalyzerViewPointHandler();
    private boolean active;
    private boolean observed;
    private int scrollDuration;
    private final AnimatedScrollPosition scrollPosition;
    private final SeedAnimator seedAnimator;

    public static SeedAnalyzerViewPointHandler getInstance() {
        return INSTANCE;
    }

    private SeedAnalyzerViewPointHandler() {
        this.setScrollDuration(10);
        this.scrollPosition = new AnimatedScrollPosition(this::getScrollDuration, () -> (int)AgriApi.getGeneRegistry().stream().filter(gene -> !gene.isHidden()).count());
        this.seedAnimator = new SeedAnimator();
    }

    public int getScrollDuration() {
        return this.scrollDuration;
    }

    public void setScrollDuration(int duration) {
        this.scrollDuration = duration;
    }

    protected AnimatedScrollPosition getScrollPosition() {
        return this.scrollPosition;
    }

    protected SeedAnimator getSeedAnimator() {
        return this.seedAnimator;
    }

    public void setActive(boolean active) {
        this.active = active;
        this.getScrollPosition().reset();
        this.getSeedAnimator().onActivation(active);
        PlayerAngleLocker.storePlayerAngles();
    }

    public void setObserved(boolean observed) {
        this.observed = observed;
        this.getScrollPosition().reset();
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isObserved() {
        return this.observed;
    }

    public int getScrollIndex() {
        return this.getScrollPosition().getIndex();
    }

    public float getPartialScrollProgress(float partialTick) {
        return this.getScrollPosition().getProgress(partialTick);
    }

    public void applySeedAnimation(TileEntitySeedAnalyzer analyzer, float partialTicks, MatrixStack transforms) {
        this.getSeedAnimator().applyAnimation(analyzer, partialTicks, transforms);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (this.isActive()) {
            boolean up = Minecraft.func_71410_x().field_71474_y.field_74351_w.func_151470_d();
            boolean down = Minecraft.func_71410_x().field_71474_y.field_74368_y.func_151470_d();
            boolean left = Minecraft.func_71410_x().field_71474_y.field_74370_x.func_151470_d();
            boolean right = Minecraft.func_71410_x().field_71474_y.field_74366_z.func_151470_d();
            if (up || down || left || right) {
                ModuleDynamicCamera.getInstance().stopObserving();
            } else if (this.isObserved()) {
                this.getScrollPosition().tick();
            }
            PlayerAngleLocker.forcePlayerAngles();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onMouseScroll(InputEvent.MouseScrollEvent event) {
        if (this.isActive()) {
            this.getScrollPosition().scroll((int)event.getScrollDelta());
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onMouseClick(InputEvent.ClickInputEvent event) {
        if (this.isActive()) {
            event.setSwingHand(false);
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onMovement(InputUpdateEvent event) {
        if (this.isActive()) {
            event.getMovementInput().field_228350_h_ = false;
            event.getMovementInput().field_78901_c = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onGuiOpened(GuiOpenEvent event) {
        if (this.isActive() && event.getGui() != null) {
            if (event.getGui() instanceof ChatScreen) {
                return;
            }
            ModuleDynamicCamera.getInstance().stopObserving();
            if (event.getGui() instanceof IngameMenuScreen) {
                event.setResult(Event.Result.DENY);
                event.setCanceled(true);
            }
        }
    }

    public static class SeedAnimator {
        private static final float HALF = 0.5f;
        private static final float DX = 0.0f;
        private static final float DY = -0.25f;
        private static final float DZ = -0.0625f;
        private static final int PITCH = 90;
        private static final Quaternion ROTATION_PITCH = new Quaternion(Vector3f.field_229179_b_, 90.0f, true);
        private float angle;

        protected void onActivation(boolean status) {
            this.angle = status ? this.calculateAngle() : 0.0f;
        }

        protected void applyAnimation(TileEntitySeedAnalyzer analyzer, float partialTicks, MatrixStack transforms) {
            transforms.func_227861_a_(0.5, 0.5, 0.5);
            switch (this.getObservationStatus(analyzer)) {
                case IDLE: {
                    this.applyIdleTransformation(transforms);
                    break;
                }
                case POSITIONING: {
                    this.applyPositioningTransformation(analyzer, partialTicks, transforms);
                    break;
                }
                case OBSERVING: {
                    this.applyObservingTransformation(analyzer, transforms);
                    break;
                }
                case RETURNING: {
                    this.applyReturningTransformation(analyzer, partialTicks, transforms);
                }
            }
            transforms.func_227862_a_(0.5f, 0.5f, 0.5f);
        }

        protected void applyIdleTransformation(MatrixStack transforms) {
            transforms.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, this.calculateAngle(), true));
        }

        protected void applyPositioningTransformation(TileEntitySeedAnalyzer analyzer, float partialTicks, MatrixStack transforms) {
            float f = ((float)this.getAnimationFrame(analyzer) + partialTicks) / (float)analyzer.getTransitionDuration();
            float yaw = MathHelper.func_219805_h((float)f, (float)this.angle, (float)analyzer.getHorizontalAngle());
            transforms.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, yaw, true));
            transforms.func_227861_a_((double)MathHelper.func_219799_g((float)f, (float)0.0f, (float)0.0f), (double)MathHelper.func_219799_g((float)f, (float)0.0f, (float)-0.25f), (double)MathHelper.func_219799_g((float)f, (float)0.0f, (float)-0.0625f));
            float pitch = MathHelper.func_219799_g((float)f, (float)0.0f, (float)90.0f);
            transforms.func_227863_a_(new Quaternion(Vector3f.field_229179_b_, pitch, true));
        }

        protected void applyObservingTransformation(TileEntitySeedAnalyzer analyzer, MatrixStack transforms) {
            transforms.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, analyzer.getHorizontalAngle(), true));
            transforms.func_227861_a_(0.0, -0.25, -0.0625);
            transforms.func_227863_a_(ROTATION_PITCH);
        }

        protected void applyReturningTransformation(TileEntitySeedAnalyzer analyzer, float partialTicks, MatrixStack transforms) {
            float f = ((float)this.getAnimationFrame(analyzer) + partialTicks) / (float)analyzer.getTransitionDuration();
            float yaw = MathHelper.func_219805_h((float)f, (float)analyzer.getHorizontalAngle(), (float)this.calculateAngle());
            transforms.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, yaw, true));
            transforms.func_227861_a_((double)MathHelper.func_219799_g((float)f, (float)0.0f, (float)0.0f), (double)MathHelper.func_219799_g((float)f, (float)-0.25f, (float)0.0f), (double)MathHelper.func_219799_g((float)f, (float)-0.0625f, (float)0.0f));
            float pitch = MathHelper.func_219799_g((float)f, (float)90.0f, (float)0.0f);
            transforms.func_227863_a_(new Quaternion(Vector3f.field_229179_b_, pitch, true));
        }

        protected DynamicCamera.Status getObservationStatus(TileEntitySeedAnalyzer analyzer) {
            if (analyzer.isObserved()) {
                return ModuleDynamicCamera.getInstance().getCameraStatus();
            }
            return DynamicCamera.Status.IDLE;
        }

        protected int getAnimationFrame(TileEntitySeedAnalyzer analyzer) {
            if (analyzer.isObserved()) {
                return ModuleDynamicCamera.getInstance().getCameraAnimationFrame();
            }
            return 0;
        }

        protected float calculateAngle() {
            return (float)(720.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0);
        }
    }
}

