/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.content.tools;

import com.google.common.collect.ImmutableSet;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.content.items.IAgriTrowelItem;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.crop.IAgriGrowthStage;
import com.infinityraider.agricraft.api.v1.event.AgriCropEvent;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenome;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.config.Config;
import com.infinityraider.agricraft.content.AgriTabs;
import com.infinityraider.agricraft.content.core.TileEntityCropSticks;
import com.infinityraider.agricraft.impl.v1.plant.NoPlant;
import com.infinityraider.agricraft.reference.AgriToolTips;
import com.infinityraider.infinitylib.item.InfinityItemProperty;
import com.infinityraider.infinitylib.item.ItemBase;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ItemTrowel
extends ItemBase
implements IAgriTrowelItem {
    private static final IAgriPlant NO_PLANT = NoPlant.getInstance();

    public ItemTrowel() {
        super("agri_trowel", new Item.Properties().func_200916_a(AgriTabs.TAB_AGRICRAFT).func_200917_a(1));
    }

    @Override
    public boolean hasPlant(ItemStack stack) {
        return this.getGenome(stack).isPresent();
    }

    @Override
    public boolean setPlant(ItemStack stack, IAgriGenome genome, IAgriGrowthStage stage) {
        CompoundNBT genomeTag;
        if (this.hasPlant(stack)) {
            return false;
        }
        CompoundNBT tag = null;
        if (stack.func_77942_o()) {
            tag = stack.func_77978_p();
        }
        if (tag == null) {
            tag = new CompoundNBT();
            stack.func_77982_d(tag);
        }
        if (!genome.writeToNBT(genomeTag = new CompoundNBT())) {
            return false;
        }
        tag.func_218657_a("agri_genome", (INBT)genomeTag);
        tag.func_74778_a("agri_growth", stage.getId());
        return true;
    }

    @Override
    public boolean removePlant(ItemStack stack) {
        if (this.hasPlant(stack)) {
            stack.func_77982_d(null);
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public Optional<IAgriGenome> getGenome(ItemStack stack) {
        CompoundNBT tag = this.checkNBT(stack);
        if (tag == null) {
            return Optional.empty();
        }
        IAgriGenome genome = AgriApi.getAgriGenomeBuilder(NO_PLANT).build();
        if (!genome.readFromNBT(tag.func_74775_l("agri_genome"))) {
            return Optional.empty();
        }
        return genome.getPlant().isPlant() ? Optional.of(genome) : Optional.empty();
    }

    @Override
    public Optional<IAgriGrowthStage> getGrowthStage(ItemStack stack) {
        CompoundNBT tag = this.checkNBT(stack);
        if (tag == null) {
            return Optional.empty();
        }
        return AgriApi.getGrowthStageRegistry().get(tag.func_74779_i("agri_growth"));
    }

    @Nullable
    protected CompoundNBT checkNBT(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b("agri_genome") || !tag.func_74764_b("agri_growth")) {
            return null;
        }
        return tag;
    }

    @Nonnull
    public ActionResultType func_195939_a(@Nonnull ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        ItemStack stack = context.func_195996_i();
        PlayerEntity player = context.func_195999_j();
        return AgriApi.getCrop((IBlockReader)world, pos).map(crop -> this.tryUseOnCrop((IAgriCrop)crop, stack, player)).orElseGet(() -> this.tryPlantOnSoil(world, pos, stack, player));
    }

    protected ActionResultType tryUseOnCrop(IAgriCrop crop, ItemStack stack, @Nullable PlayerEntity player) {
        if (crop.hasWeeds()) {
            if (player != null) {
                player.func_145747_a(AgriToolTips.MSG_TROWEL_WEED, player.func_110124_au());
            }
        } else {
            if (crop.isCrossCrop()) {
                return ActionResultType.FAIL;
            }
            if (!MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Trowel.Pre(crop, stack, (LivingEntity)player))) {
                if (crop.hasPlant()) {
                    return this.tryPickUpPlant(crop, stack, player);
                }
                return this.tryPlantOnCropSticks(crop, stack, player);
            }
        }
        return ActionResultType.FAIL;
    }

    protected ActionResultType tryPickUpPlant(IAgriCrop crop, ItemStack stack, @Nullable PlayerEntity player) {
        if (crop.world() == null || crop.world().func_201670_d()) {
            return ActionResultType.PASS;
        }
        if (this.hasPlant(stack)) {
            if (player != null) {
                player.func_145747_a(AgriToolTips.MSG_TROWEL_PLANT, player.func_110124_au());
            }
            return ActionResultType.FAIL;
        }
        crop.getGenome().ifPresent(genome -> {
            this.setPlant(stack, (IAgriGenome)genome, crop.getGrowthStage());
            crop.removeGenome();
        });
        MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Trowel.Post(crop, stack, (LivingEntity)player));
        return ActionResultType.SUCCESS;
    }

    protected ActionResultType tryPlantOnCropSticks(IAgriCrop crop, ItemStack stack, @Nullable PlayerEntity player) {
        if (crop.world() == null || crop.world().func_201670_d()) {
            return ActionResultType.PASS;
        }
        if (crop.isCrossCrop()) {
            return ActionResultType.FAIL;
        }
        if (this.hasPlant(stack)) {
            if (crop.hasCropSticks()) {
                this.getGenome(stack).ifPresent(genome -> this.getGrowthStage(stack).ifPresent(growth -> {
                    this.removePlant(stack);
                    crop.plantGenome((IAgriGenome)genome, (LivingEntity)player);
                    crop.setGrowthStage((IAgriGrowthStage)growth);
                }));
            }
            MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Trowel.Post(crop, stack, (LivingEntity)player));
            return ActionResultType.SUCCESS;
        }
        if (player != null) {
            player.func_145747_a(AgriToolTips.MSG_TROWEL_NO_PLANT, player.func_110124_au());
        }
        return ActionResultType.FAIL;
    }

    protected ActionResultType tryPlantOnSoil(World world, BlockPos pos, ItemStack stack, @Nullable PlayerEntity player) {
        if (this.hasPlant(stack)) {
            BlockPos up = pos.func_177984_a();
            TileEntity tile = world.func_175625_s(up);
            if (tile instanceof TileEntityCropSticks) {
                return this.tryPlantOnCropSticks((TileEntityCropSticks)tile, stack, player);
            }
            return this.tryNewPlant(world, up, stack, player);
        }
        return ActionResultType.FAIL;
    }

    protected ActionResultType tryNewPlant(World world, BlockPos pos, ItemStack stack, @Nullable PlayerEntity player) {
        BlockState newState;
        if (((Config)AgriCraft.instance.getConfig()).allowPlantingOutsideCropSticks() && (newState = AgriCraft.instance.getModBlockRegistry().crop_plant.getStateForPlacement(world, pos)) != null && world.func_180501_a(pos, newState, 11)) {
            boolean success = AgriApi.getCrop((IBlockReader)world, pos).map(crop -> {
                if (MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Trowel.Pre((IAgriCrop)crop, stack, (LivingEntity)player))) {
                    return false;
                }
                return this.getGenome(stack).map(genome -> this.getGrowthStage(stack).map(stage -> {
                    boolean result;
                    boolean bl = result = crop.plantGenome((IAgriGenome)genome, (LivingEntity)player) && this.setGrowthStage((IAgriCrop)crop, (IAgriGrowthStage)stage);
                    if (result) {
                        this.removePlant(stack);
                        MinecraftForge.EVENT_BUS.post((Event)new AgriCropEvent.Trowel.Post((IAgriCrop)crop, stack, (LivingEntity)player));
                    }
                    return result;
                }).orElse(false)).orElse(false);
            }).orElse(false);
            if (success) {
                return ActionResultType.SUCCESS;
            }
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
        return ActionResultType.FAIL;
    }

    protected boolean setGrowthStage(IAgriCrop crop, IAgriGrowthStage stage) {
        if (crop.getGrowthStage().equals(stage)) {
            return true;
        }
        return crop.setGrowthStage(stage);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Set<InfinityItemProperty> getModelProperties() {
        return ImmutableSet.of((Object)new InfinityItemProperty(new ResourceLocation(AgriCraft.instance.getModId(), "plant")){

            public float getValue(ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity entity) {
                return !stack.func_190926_b() && stack.func_77973_b() instanceof IAgriTrowelItem && ((IAgriTrowelItem)stack.func_77973_b()).hasPlant(stack) ? 1.0f : 0.0f;
            }
        });
    }
}

