/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.content.irrigation;

import com.google.common.collect.Maps;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.content.irrigation.BlockIrrigationChannelAbstract;
import com.infinityraider.agricraft.content.irrigation.ItemIrrigationChannel;
import com.infinityraider.agricraft.content.irrigation.TileEntityIrrigationChannel;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BlockIrrigationChannelNormal
extends BlockIrrigationChannelAbstract {
    private static final Map<BlockState, VoxelShape> SHAPES = Maps.newHashMap();

    public static VoxelShape getShape(BlockState state) {
        return SHAPES.computeIfAbsent(state, aState -> Stream.concat(Stream.of(((BlockIrrigationChannelAbstract.Valve)((Object)((Object)VALVE.fetch(state)))).hasValve() ? Shapes.BASE_VALVE : Shapes.BASE), Arrays.stream(Direction.values()).map(dir -> BlockIrrigationChannelNormal.getConnection(dir).map(prop -> {
            boolean connected = (Boolean)prop.fetch(aState);
            switch (dir) {
                case NORTH: {
                    return connected ? Shapes.CHANNEL_NORTH : Shapes.NONE_NORTH;
                }
                case SOUTH: {
                    return connected ? Shapes.CHANNEL_SOUTH : Shapes.NONE_SOUTH;
                }
                case WEST: {
                    return connected ? Shapes.CHANNEL_WEST : Shapes.NONE_WEST;
                }
                case EAST: {
                    return connected ? Shapes.CHANNEL_EAST : Shapes.NONE_EAST;
                }
            }
            return VoxelShapes.func_197880_a();
        })).filter(Optional::isPresent).map(Optional::get)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get());
    }

    public BlockIrrigationChannelNormal() {
        super("irrigation_channel", true, AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_226896_b_());
    }

    @Nonnull
    public ItemIrrigationChannel asItem() {
        return AgriCraft.instance.getModItemRegistry().channel;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        BlockIrrigationChannelAbstract.Valve valve = (BlockIrrigationChannelAbstract.Valve)((Object)BlockIrrigationChannelAbstract.VALVE.fetch(state));
        if (valve.hasValve()) {
            world.func_175656_a(pos, BlockIrrigationChannelAbstract.VALVE.apply(state, (Comparable)((Object)valve.toggleValve())));
            if (world.func_201670_d()) {
                TileEntity tile = world.func_175625_s(pos);
                if (tile instanceof TileEntityIrrigationChannel) {
                    TileEntityIrrigationChannel channel = (TileEntityIrrigationChannel)tile;
                    channel.setValveState(((BlockIrrigationChannelAbstract.Valve)((Object)BlockIrrigationChannelAbstract.VALVE.fetch(state))).canTransfer() ? TileEntityIrrigationChannel.ValveState.CLOSING : TileEntityIrrigationChannel.ValveState.OPENING);
                }
            } else {
                this.playValveSound(world, pos);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Deprecated
    public VoxelShape func_196247_c(BlockState state, IBlockReader world, BlockPos pos) {
        return this.func_220053_a(state, world, pos, ISelectionContext.func_216377_a());
    }

    @Deprecated
    public VoxelShape func_230335_e_(BlockState state, IBlockReader world, BlockPos pos) {
        return this.func_220071_b(state, world, pos, ISelectionContext.func_216377_a());
    }

    @Deprecated
    public VoxelShape func_199600_g(BlockState state, IBlockReader world, BlockPos pos) {
        return this.func_230322_a_(state, world, pos, ISelectionContext.func_216377_a());
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return BlockIrrigationChannelNormal.getShape(state);
    }

    @Deprecated
    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this.func_220053_a(state, world, pos, context);
    }

    @Deprecated
    public VoxelShape func_230322_a_(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this.func_220053_a(state, world, pos, context);
    }

    public static final class Shapes {
        public static final VoxelShape BASE = Stream.of(Block.func_208617_a((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0), Block.func_208617_a((double)5.0, (double)6.0, (double)5.0, (double)6.0, (double)10.0, (double)6.0), Block.func_208617_a((double)5.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)11.0), Block.func_208617_a((double)10.0, (double)6.0, (double)5.0, (double)11.0, (double)10.0, (double)6.0), Block.func_208617_a((double)10.0, (double)6.0, (double)10.0, (double)11.0, (double)10.0, (double)11.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
        public static final VoxelShape BASE_VALVE = Stream.of(BASE, Block.func_208617_a((double)5.0, (double)10.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
        public static final VoxelShape CHANNEL_NORTH = Stream.of(Block.func_208617_a((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)6.0, (double)5.0), Block.func_208617_a((double)5.0, (double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)5.0), Block.func_208617_a((double)10.0, (double)6.0, (double)0.0, (double)11.0, (double)10.0, (double)5.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
        public static final VoxelShape CHANNEL_SOUTH = CHANNEL_NORTH.func_197751_a(0.0, 0.0, 0.6875);
        public static final VoxelShape CHANNEL_WEST = Stream.of(Block.func_208617_a((double)0.0, (double)5.0, (double)5.0, (double)5.0, (double)6.0, (double)11.0), Block.func_208617_a((double)0.0, (double)6.0, (double)5.0, (double)5.0, (double)10.0, (double)6.0), Block.func_208617_a((double)0.0, (double)6.0, (double)10.0, (double)5.0, (double)10.0, (double)11.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
        public static final VoxelShape CHANNEL_EAST = CHANNEL_WEST.func_197751_a(0.6875, 0.0, 0.0);
        public static final VoxelShape NONE_NORTH = Block.func_208617_a((double)6.0, (double)6.0, (double)5.0, (double)10.0, (double)10.0, (double)6.0);
        public static final VoxelShape NONE_SOUTH = NONE_NORTH.func_197751_a(0.0, 0.0, 0.3125);
        public static final VoxelShape NONE_WEST = Block.func_208617_a((double)5.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0);
        public static final VoxelShape NONE_EAST = NONE_WEST.func_197751_a(0.3125, 0.0, 0.0);

        private Shapes() {
        }
    }
}

