/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.content.irrigation;

import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.content.irrigation.TileEntityIrrigationChannel;
import com.infinityraider.agricraft.content.irrigation.TileEntityIrrigationComponent;
import com.infinityraider.infinitylib.block.BlockDynamicTexture;
import com.infinityraider.infinitylib.block.property.InfProperty;
import com.infinityraider.infinitylib.block.property.InfPropertyConfiguration;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class BlockIrrigationChannelAbstract
extends BlockDynamicTexture<TileEntityIrrigationChannel> {
    public static final InfProperty<Boolean> NORTH = InfProperty.Creators.create((String)"north", (boolean)false);
    public static final InfProperty<Boolean> EAST = InfProperty.Creators.create((String)"east", (boolean)false);
    public static final InfProperty<Boolean> SOUTH = InfProperty.Creators.create((String)"south", (boolean)false);
    public static final InfProperty<Boolean> WEST = InfProperty.Creators.create((String)"west", (boolean)false);
    public static final InfProperty<Valve> VALVE = InfProperty.Creators.create((String)"valve", Valve.class, (Enum)Valve.NONE);
    private static final InfPropertyConfiguration PROPERTIES = InfPropertyConfiguration.builder().add(NORTH).add(EAST).add(SOUTH).add(WEST).add(VALVE).build();
    private static final BiFunction<BlockState, IBlockReader, TileEntityIrrigationChannel> TILE_FACTORY = (s, w) -> new TileEntityIrrigationChannel();
    private final boolean handWheel;

    public static Optional<InfProperty<Boolean>> getConnection(Direction direction) {
        switch (direction) {
            case NORTH: {
                return Optional.of(NORTH);
            }
            case SOUTH: {
                return Optional.of(SOUTH);
            }
            case EAST: {
                return Optional.of(EAST);
            }
            case WEST: {
                return Optional.of(WEST);
            }
        }
        return Optional.empty();
    }

    public BlockIrrigationChannelAbstract(String name, boolean handWheel, AbstractBlock.Properties properties) {
        super(name, properties);
        this.handWheel = handWheel;
    }

    public boolean hasHandWheel() {
        return this.handWheel;
    }

    public void addDrops(Consumer<ItemStack> dropAcceptor, BlockState state, TileEntityIrrigationChannel tile, LootContext.Builder context) {
        if (((Valve)((Object)VALVE.fetch(state))).hasValve()) {
            dropAcceptor.accept(new ItemStack((IItemProvider)AgriCraft.instance.getModItemRegistry().valve, 1));
        }
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState state = this.func_176223_P();
        for (Direction dir : Direction.values()) {
            TileEntityIrrigationComponent component;
            TileEntity tile;
            Optional<InfProperty<Boolean>> prop = BlockIrrigationChannelAbstract.getConnection(dir);
            if (!prop.isPresent() || !((tile = world.func_175625_s(pos.func_177972_a(dir))) instanceof TileEntityIrrigationComponent) || !(component = (TileEntityIrrigationComponent)tile).isSameMaterial(context.func_195996_i())) continue;
            state = prop.get().apply(state, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public BlockState func_196271_a(BlockState ownState, Direction dir, BlockState otherState, IWorld world, BlockPos pos, BlockPos otherPos) {
        return BlockIrrigationChannelAbstract.getConnection(dir).map(prop -> {
            TileEntityIrrigationComponent other;
            TileEntity otherTile = world.func_175625_s(otherPos);
            TileEntity ownTile = world.func_175625_s(pos);
            if (ownTile instanceof TileEntityIrrigationChannel && otherTile instanceof TileEntityIrrigationComponent && (other = (TileEntityIrrigationComponent)otherTile).canConnect((TileEntityIrrigationChannel)ownTile)) {
                return prop.apply(ownState, (Comparable)Boolean.valueOf(true));
            }
            return prop.apply(ownState, (Comparable)Boolean.valueOf(false));
        }).orElse(super.func_196271_a(ownState, dir, otherState, world, pos, otherPos));
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityIrrigationChannel) {
            ((TileEntityIrrigationChannel)tile).onNeighbourUpdate(fromPos);
        }
        super.func_220069_a(state, world, pos, block, fromPos, isMoving);
    }

    public void onBlockPlacedBy(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack, @Nullable TileEntity tile) {
        if (tile instanceof TileEntityIrrigationChannel) {
            TileEntityIrrigationChannel channel = (TileEntityIrrigationChannel)tile;
            channel.onNeighbourUpdate(Direction.NORTH);
            channel.onNeighbourUpdate(Direction.EAST);
            channel.onNeighbourUpdate(Direction.SOUTH);
            channel.onNeighbourUpdate(Direction.WEST);
        }
    }

    protected InfPropertyConfiguration getPropertyConfiguration() {
        return PROPERTIES;
    }

    public BiFunction<BlockState, IBlockReader, TileEntityIrrigationChannel> getTileEntityFactory() {
        return TILE_FACTORY;
    }

    public void playValveSound(World world, BlockPos pos) {
        world.func_184133_a(null, pos, (SoundEvent)AgriCraft.instance.getModSoundRegistry().valve, SoundCategory.BLOCKS, 2.5f, 2.6f + (world.func_201674_k().nextFloat() - world.func_201674_k().nextFloat()) * 0.8f);
    }

    public static enum Valve implements IStringSerializable
    {
        NONE(true, false),
        OPEN(true, true),
        CLOSED(false, true);

        private final boolean transfer;
        private final boolean valve;

        private Valve(boolean transfer, boolean valve) {
            this.transfer = transfer;
            this.valve = valve;
        }

        public boolean canTransfer() {
            return this.transfer;
        }

        public boolean hasValve() {
            return this.valve;
        }

        public Valve toggleValve() {
            if (this.hasValve()) {
                return this.canTransfer() ? CLOSED : OPEN;
            }
            return NONE;
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }
}

