/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.content.core;

import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.content.core.ItemCropSticks;
import com.infinityraider.agricraft.util.FluidPredicates;
import com.infinityraider.infinitylib.block.BlockBase;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluid;

public enum CropStickVariant {
    WOOD(Material.field_151585_k, 3, SoundType.field_185848_a, () -> () -> AgriCraft.instance.getModItemRegistry().crop_sticks_wood, () -> () -> AgriCraft.instance.getModBlockRegistry().crop_sticks_wood, FluidPredicates.NOT_LAVA),
    IRON(Material.field_151585_k, 7, SoundType.field_185858_k, () -> () -> AgriCraft.instance.getModItemRegistry().crop_sticks_iron, () -> () -> AgriCraft.instance.getModBlockRegistry().crop_sticks_iron, FluidPredicates.ANY_FLUID),
    OBSIDIAN(Material.field_151585_k, 7, SoundType.field_235587_I_, () -> () -> AgriCraft.instance.getModItemRegistry().crop_sticks_obsidian, () -> () -> AgriCraft.instance.getModBlockRegistry().crop_sticks_obsidian, FluidPredicates.ANY_FLUID);

    private final String id = "crop_sticks_" + this.name().toLowerCase();
    private final int strength;
    private final SoundType sound;
    private final Material material;
    private final Supplier<Supplier<ItemCropSticks>> itemSupplier;
    private final Supplier<Supplier<BlockBase>> blockSupplier;
    private final Predicate<Fluid> fluidPredicate;

    private CropStickVariant(Material material, int strength, SoundType sound, Supplier<Supplier<ItemCropSticks>> itemSupplier, Supplier<Supplier<BlockBase>> blockSupplier, Predicate<Fluid> fluidPredicate) {
        this.strength = strength;
        this.sound = sound;
        this.material = material;
        this.itemSupplier = itemSupplier;
        this.blockSupplier = blockSupplier;
        this.fluidPredicate = fluidPredicate;
    }

    public final String getId() {
        return this.id;
    }

    public final int getStrength() {
        return this.strength;
    }

    public final SoundType getSound() {
        return this.sound;
    }

    public final Material getMaterial() {
        return this.material;
    }

    public final ItemCropSticks getItem() {
        return this.itemSupplier.get().get();
    }

    public final BlockBase getBlock() {
        return this.blockSupplier.get().get();
    }

    public final boolean canExistInFluid(Fluid fluid) {
        return this.fluidPredicate.test(fluid);
    }
}

