/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.capability;

import com.google.common.collect.Sets;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.genetics.IAgriMutation;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.config.Config;
import com.infinityraider.agricraft.network.MessageSyncResearchCapability;
import com.infinityraider.agricraft.plugins.jei.JeiBridge;
import com.infinityraider.infinitylib.capability.IInfSerializableCapabilityImplementation;
import com.infinityraider.infinitylib.utility.ISerializable;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class CapabilityResearchedPlants
implements IInfSerializableCapabilityImplementation<PlayerEntity, Impl> {
    private static final CapabilityResearchedPlants INSTANCE = new CapabilityResearchedPlants();
    public static ResourceLocation KEY = new ResourceLocation(AgriCraft.instance.getModId().toLowerCase(), "research");
    @CapabilityInject(value=Impl.class)
    public static final Capability<Impl> CAPABILITY = null;

    public static CapabilityResearchedPlants getInstance() {
        return INSTANCE;
    }

    private CapabilityResearchedPlants() {
    }

    public void researchPlant(@Nullable PlayerEntity player, IAgriPlant plant) {
        if (player != null) {
            this.getCapability((ICapabilityProvider)player).ifPresent(impl -> impl.researchPlant(plant));
        }
    }

    public boolean isPlantResearched(@Nullable PlayerEntity player, IAgriPlant plant) {
        return player != null && this.getCapability((ICapabilityProvider)player).map(impl -> impl.isPlantResearched(plant)).orElse(false) != false;
    }

    public boolean isMutationResearched(@Nullable PlayerEntity player, IAgriMutation mutation) {
        return player != null && this.getCapability((ICapabilityProvider)player).map(impl -> impl.isMutationResearched(mutation)).orElse(false) != false;
    }

    public void configureJei(PlayerEntity player) {
        this.getCapability((ICapabilityProvider)player).ifPresent(Impl::configureJei);
    }

    public Class<Impl> getCapabilityClass() {
        return Impl.class;
    }

    public Capability<Impl> getCapability() {
        return CAPABILITY;
    }

    public boolean shouldApplyCapability(PlayerEntity carrier) {
        return true;
    }

    public Impl createNewValue(PlayerEntity carrier) {
        return new Impl(carrier);
    }

    public ResourceLocation getCapabilityKey() {
        return KEY;
    }

    public Class<PlayerEntity> getCarrierClass() {
        return PlayerEntity.class;
    }

    public void copyData(Impl from, Impl to) {
        to.copyFrom(from);
    }

    public static class Impl
    implements ISerializable {
        private final PlayerEntity player;
        private final Set<String> unlockedPlants;

        protected Impl(PlayerEntity player) {
            this.player = player;
            this.unlockedPlants = Sets.newHashSet();
        }

        public PlayerEntity getPlayer() {
            return this.player;
        }

        public void researchPlant(IAgriPlant plant) {
            this.unlockedPlants.add(plant.getId());
            if (AgriCraft.instance.getEffectiveSide().isServer()) {
                new MessageSyncResearchCapability(this).sendTo(this.player);
            }
        }

        public boolean isPlantResearched(IAgriPlant plant) {
            return this.unlockedPlants.contains(plant.getId());
        }

        public boolean isMutationResearched(IAgriMutation mutation) {
            return this.isPlantResearched(mutation.getChild()) || mutation.getParents().stream().anyMatch(this::isPlantResearched);
        }

        public void configureJei() {
            if (AgriCraft.instance.getEffectiveSide().isClient()) {
                if (((Config)AgriCraft.instance.getConfig()).progressiveJEI()) {
                    AgriApi.getMutationRegistry().stream().forEach(mutation -> {
                        if (this.isMutationResearched((IAgriMutation)mutation)) {
                            JeiBridge.unHideMutation(mutation);
                        } else {
                            JeiBridge.hideMutation(mutation);
                        }
                    });
                }
            } else {
                new MessageSyncResearchCapability(this).sendTo(this.player);
            }
        }

        protected void copyFrom(Impl other) {
            if (this == other) {
                return;
            }
            this.unlockedPlants.clear();
            this.unlockedPlants.addAll(other.unlockedPlants);
        }

        public void readFromNBT(CompoundNBT tag) {
            this.unlockedPlants.clear();
            if (tag.func_74764_b("agri_entries")) {
                ListNBT list = tag.func_150295_c("agri_entries", 8);
                list.forEach(entry -> {
                    if (entry instanceof StringNBT) {
                        this.unlockedPlants.add(entry.func_150285_a_());
                    }
                });
            }
        }

        public CompoundNBT writeToNBT() {
            CompoundNBT tag = new CompoundNBT();
            ListNBT list = new ListNBT();
            this.unlockedPlants.stream().map(StringNBT::func_229705_a_).forEach(arg_0 -> list.add(arg_0));
            tag.func_218657_a("agri_entries", (INBT)list);
            return tag;
        }
    }
}

