/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.v1.requirement;

import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.requirement.IAgriSoil;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public final class AnySoilIngredient
extends Ingredient {
    private static final AnySoilIngredient INSTANCE = new AnySoilIngredient();
    private ItemStack[] matchingStacks;

    public static AnySoilIngredient getInstance() {
        return INSTANCE;
    }

    private AnySoilIngredient() {
        super(Stream.of(new Ingredient.SingleItemList(new ItemStack((IItemProvider)Blocks.field_150458_ak))));
    }

    public boolean test(@Nullable ItemStack stack) {
        return AgriApi.getSoilRegistry().valueOf(stack).map(IAgriSoil::isSoil).orElse(false);
    }

    @Nonnull
    public ItemStack[] func_193365_a() {
        this.determineMatchingStacks();
        return this.matchingStacks;
    }

    private void determineMatchingStacks() {
        if (this.matchingStacks == null) {
            this.matchingStacks = (ItemStack[])AgriApi.getSoilRegistry().stream().flatMap(soil -> soil.getVariants().stream()).map(AbstractBlock.AbstractBlockState::func_177230_c).map(ItemStack::new).distinct().toArray(ItemStack[]::new);
        }
    }

    @Nonnull
    public IIngredientSerializer<AnySoilIngredient> getSerializer() {
        return AgriApi.getAnySoilIngredientSerializer();
    }
}

