/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.v1.event;

import com.google.common.base.Preconditions;
import com.infinityraider.agricraft.api.v1.fertilizer.IAgriFertilizer;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGene;
import com.infinityraider.agricraft.api.v1.genetics.IAgriMutation;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.plant.IAgriWeed;
import com.infinityraider.agricraft.api.v1.requirement.IAgriSoil;
import com.infinityraider.agricraft.api.v1.util.IAgriRegisterable;
import com.infinityraider.agricraft.api.v1.util.IAgriRegistry;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraftforge.eventbus.api.Event;

public class AgriRegistryEvent<T extends IAgriRegisterable<T>>
extends Event {
    private final IAgriRegistry<T> registry;
    private final T original;
    private T substitute;

    private AgriRegistryEvent(IAgriRegistry<T> registry, T element) {
        this.registry = registry;
        this.original = element;
        this.setSubstitute(element);
    }

    @Nonnull
    public IAgriRegistry<T> getRegistry() {
        return this.registry;
    }

    @Nonnull
    public T getOriginal() {
        return this.original;
    }

    @Nonnull
    public T getSubstitute() {
        return this.substitute;
    }

    public void setSubstitute(@Nonnull T substitute) {
        Objects.requireNonNull(substitute);
        Preconditions.checkArgument((boolean)substitute.getId().equals(this.getOriginal().getId()), (Object)"Substituted element must have the same id as the original");
        this.substitute = substitute;
    }

    /* synthetic */ AgriRegistryEvent(IAgriRegistry x0, IAgriRegisterable x1, 1 x2) {
        this(x0, x1);
    }

    public static class Mutation
    extends AgriRegistryEvent<IAgriMutation> {
        public Mutation(IAgriRegistry<IAgriMutation> registry, IAgriMutation element) {
            super(registry, element, null);
        }
    }

    public static class Gene
    extends AgriRegistryEvent<IAgriGene<?>> {
        public Gene(IAgriRegistry<IAgriGene<?>> registry, IAgriGene<?> element) {
            super(registry, element, null);
        }
    }

    public static class Fertilizer
    extends AgriRegistryEvent<IAgriFertilizer> {
        public Fertilizer(IAgriRegistry<IAgriFertilizer> registry, IAgriFertilizer element) {
            super(registry, element, null);
        }
    }

    public static class Soil
    extends AgriRegistryEvent<IAgriSoil> {
        public Soil(IAgriRegistry<IAgriSoil> registry, IAgriSoil element) {
            super(registry, element, null);
        }
    }

    public static class Weed
    extends AgriRegistryEvent<IAgriWeed> {
        public Weed(IAgriRegistry<IAgriWeed> registry, IAgriWeed element) {
            super(registry, element, null);
        }
    }

    public static class Plant
    extends AgriRegistryEvent<IAgriPlant> {
        public Plant(IAgriRegistry<IAgriPlant> registry, IAgriPlant element) {
            super(registry, element, null);
        }
    }
}

